<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:RKScript="urn:CustomScript"   xmlns:iMMScript="urn:CustomScript" xmlns:theScript="urn:CustomScript">
<msxsl:script implements-prefix="theScript" language="javascript"><![CDATA[	

//-------------Change the FI number according to your install. Added by Anu on 02/19/2008

//Function to get the custom associate codes
	function GetCustomAppPrefix(ownerCode, assocCode)
	{ 
		var sReturnVal="";
			switch (ownerCode){
			//Example to add ownership codes
			//case '200':
			//	sReturnVal = "CS";		// Co-signer
			//  break;
			//case '201':
			//	sReturnVal = "WD";		// Withdrawn
			//  break;
			//case '202':
			//	sReturnVal = "CO";		// Collateral owner
			//  break;
			default:
				sReturnVal = "";
			break;
		}

		return sReturnVal;
	}
		]]>
    </msxsl:script>
<msxsl:script implements-prefix="RKScript" language="javascript"><![CDATA[	

//Function to get the custom associate codes and serch key so that we  can convert them to IMM standard prefixes. 
	
	function GetCustomAssocCode(fieldname,searchkey)
	{ 
		var sReturnVal="";
		var m_varupper = fieldname;
		var m_searchkey = searchkey;

			if (fieldname==""){
				fieldname = searchkey;
			}
			else {
			fieldname =  fieldname ;
			}
			
			//Example of not using the fieldname and getting the custom assoc code only by searchkey 
			//if (searchkey=="P") {
			//	return "XX";
			//}
			
			switch (fieldname){
				//Example to add associate codes 
				//Search Key B = Association  Code available BE = Beneficiary on Account BECH (IRA only) 
				//Search Key B = Association  Code available BE = Beneficiary on Account JOCH (regular Beneficiary)
				//case 'BE':
				//	sReturnVal = "BF";
				//break;
				default:
					sReturnVal = "";
				break;
			}

		return sReturnVal;
	}
	
// Routine to return current department/Branch names and values for department/branch dropdownlist on forms.
// Variable m_deptbranchNameValue stores Department/branch Display Name and Value in the following format: 
//[Department Name]:[Department Value]; ex. ACH & Check Operations:ACH&CheckOps;
//GetDepartmentBranchValues stores values for CSTM_DEPT_BRANCH_VALUES
//GetBranchValues stores values for CSTM_BRANCH_VALUES

function GetDepartmentBranchValues() 
{
var m_deptbranchNameValue = "Anderson Road:Anderson Road;Bull Street:Bull Street;Card Services/eCommerce:Card Services/eCommerce;Cheraw:Cheraw;Chester:Chester;Chesterfield:Chesterfield;Clemson:Clemson;Clinton Hwy 76 E:Clinton Hwy 76 E;Consumer Loan:Consumer Loan;Contact Center:Contact Center;Duncan:Duncan;Ebenezer:Ebenezer;EBranch:EBranch;Gaffney:Gaffney;Galleria:Galleria;Gold Hill Road:Gold Hill Road;Indian Land:Indian Land;JB White Blvd:JB White Blvd;Kershaw:Kershaw;Killian Road:Killian Road;Laurens:Laurens;Newport:Newport;Nine West:Nine West;North Grove:North Grove;North Main:North Main;Pageland:Pageland;Peachtree:Peachtree;Recovery Services:Recovery Services;Richburg:Richburg;Russell House:Russell House;South Tryon:South Tryon;Spartanburg East Main:Spartanburg East Main;Springdale:Springdale;Union:Union";

return m_deptbranchNameValue;
}


// End Routine to return current department/branch names and values for department/branch dropdownlist on forms.	

		]]>
    </msxsl:script>
<msxsl:script implements-prefix="iMMScript" language="javascript"><![CDATA[	

//-------------Change the FI number according to your install.
var sTeAASPFilesDirectory="C:/IMM Transform/Corelation"; 
var sFIDirectory="FI2"; 


 //****************Getting the installed path***************
	//Function to get the TeAASPFiles path
	function GetTeAASPFilesDirectory()
	{ 
		return sTeAASPFilesDirectory;
		}
		
	//Function to get the FI directory path
	function GetFIDirectory()
	{ 
		var sReturnFIDirectory="";
		sReturnFIDirectory=sTeAASPFilesDirectory + "/" + sFIDirectory + "/";
		return sReturnFIDirectory;
		}
		
//*****************************************************************
 //****************Getting the co app and other applicant code***************
	//Function to get the custom spouse code if it is other than "S" 
	function GetSpouseCode()
	{ 
		var sReturnVal="";
		//sReturnVal="Co-borrower (Spouse)";
		return sReturnVal;
		}
	
//Function to get the custom app codes and find the applicant type prefixes.
	function GetCustomAppCode(fieldname)
	{ 
		var sReturnVal="";
		var sfieldvalue=fieldname.toUpperCase();
			switch (sfieldvalue){
				//Example below shows how to convert app code of J to O 
				//case 'OTHER APPLICANT':
				//	sReturnVal = "O";
				//break;
				//case 'CO APPLICANT':
				//	sReturnVal = "O";
				//break;
				default:
					sReturnVal = "";
				break;
			}

		return sReturnVal;
	}
//*****************************************************************
 //****************Reading the text file session, code and desc***************
	//Function read text file into an array
	function ReadFileintoArray() { 
		var fso, f1, ts="", s, i;   
		var ForReading = 1; 
		var nodelist = "";	
		var sSplit = "";
		var xvalue = GetFIDirectory();
		var rRet="";
		var sLine="";
		var arr_list;
		var a_code="";
		var a_desc="";
		var a_session="";
	  
		nodelist = xvalue + "/FieldDefs/Descriptions.txt";
		sSplit=('=');

		fso = new ActiveXObject("Scripting.FileSystemObject"); 
		  // Read the contents of the file. 
		  try { 
		   ts = fso.OpenTextFile(nodelist, ForReading); 
		  } 
		  catch(e) { 
		   // Error: could not read file, return filename instead to help debug 
		   return(nodelist); 
		  } 
		  while ( !ts.AtEndOfStream ){
			s = ts.ReadLine();
			sLine= s;
			
			if (sLine.substring(0,2)!="--"){
				arr_list = sLine.split(sSplit);
				a_code=arr_list[0];
				a_desc=arr_list[1];
				a_desc = DescriptionsJSTrim(a_desc);
				
				if (a_code== "SESSION"){
					a_session = a_desc;
				}
				else
				{
					GetDescType(a_session,a_code,a_desc);
				}
			}

		  }
		  ts.Close();  
	 
		return "";
	
	}

	function DescriptionsJSTrim(sString) 
	{ 
		  var sReturnString = new String("" + sString); 

		  for (var i=0; i<sReturnString.length; i++) 
		  { 
				if ( sReturnString.charAt(i) != " " ) 
					  break; 
		  } 

		  if ( i > 0 ) 
				sReturnString = sReturnString.slice(i, sReturnString.length) 

		  for (var i=sReturnString.length-1; i>=0; i -= 1) 
		  { 
				if ( sReturnString.charAt(i) != " " ) 
					  break; 
		  } 

		  if ( i > 0 ) 
				sReturnString = sReturnString.slice(0, i+1) 

		  return "" + sReturnString; 
	}	
//*****************************************************************
//****************Keeping track of types and desc accordingly***************
	//*****Creating array list
	var DescMultiArray=new Array();
	var DescMultiTypeValueArray = new Array();
	var DescMultiDescValueArray = new Array();
	var DescMultiCountArray = new Array();
	var g_Count=0;
	var arr_Count=0;


	function GetDescType(sSession,sType, sDesc) 
	{	 
		var x = 0;
		x = DescMultiArray.length;
		var i = 0;
		var m_exit = "false";
		var returnvar = 0;


				
		if (x == 0){
		DescMultiArray[0] = "NA";
		DescMultiTypeValueArray[0] = "NA";
		DescMultiDescValueArray[0] = "NA";
		DescMultiCountArray[0] = 0;
		}
		else{
        for (i=0;i<=x;i++) 
        { 	
          if (DescMultiArray[i] == sType)
            {
			  DescMultiTypeValueArray[i] =sType;
			  DescMultiDescValueArray[i] =sDesc;
			  DescMultiCountArray[i] = DescMultiCountArray[i]+1
			  m_exit = "true"; 
			  returnvar = DescMultiCountArray[i];
            }
		}  
}  		
		
		if((m_exit == 'false') && (i > x))
		{ 
			DescMultiArray[x] = sSession;
			DescMultiTypeValueArray[x] =sType;
			DescMultiDescValueArray[x] =sDesc;
			DescMultiCountArray[x] = 1;		
			returnvar = DescMultiCountArray[x];
		}	
		
		return "" + returnvar;
	} 
	//*****Getting the length of the array
	function DescArrLength() {	 
	 var returnvar="";
	returnvar = DescMultiArray.length;
	return returnvar;
	 } 
	//*****Getting the Code from the array list
	 function GetDescArrCode(aSession,aType) {	 
		var returnvar="";
		var x = 0;
		x = DescMultiArray.length;
		
		var sSession="[" + aSession.toUpperCase() + "]";
		var sType=aType.toUpperCase();
				
		var i = 0;
		for (i=0;i<=x;i++) 
		{ 	
		  if (DescMultiArray[i] == sSession)
			{
				 if (DescMultiTypeValueArray[i] == sType)
				 {
					 returnvar = DescMultiDescValueArray[i];
					 break;
				 }
			}
		}    
		return returnvar;
	 } 
	 
	 var LIMultiValueArrays = new Array();
	 //*****Getting the Code from the array list
	 function GetArrCodes(aSession,aType) {	 
		var returnvar="";
		var x = 0;
		x = DescMultiArray.length;
		var sAbbValue="";
		var xLen =0;
		var iIndex=0;
		var sSession="[" + aSession.toUpperCase() + "]";
		var sType=aType.toUpperCase();
		var arr_list;
		var sTemp="";
				
		var i = 0;
		for (i=0;i<=x;i++) 
		{ 	
		  if (DescMultiArray[i] == sSession)
			{
				 if (DescMultiTypeValueArray[i] == sType)
				 {
					sAbbValue = DescMultiDescValueArray[i];
					
					if (sAbbValue.indexOf(",") >1){
					arr_list = sAbbValue.split(",");
					xLen= arr_list.length;

					for (iIndex=0;iIndex<=xLen-1;iIndex++) 
					{ 	
						sTemp=CreateGenericArr(arr_list[iIndex],iIndex);
					} 
				}
				else
				{
					sTemp=CreateGenericArr(sAbbValue,"0");
				}
					 //break;
				 }
			}
		}    
		return LIMultiValueArrays.length;
	 } 
	 
		
		
	 	//Function to create generic array
		function CreateGenericArr(m_return,iIndex) {	 
		var x = 0;
		x = arr_Count;
		var i = 0;
		var m_exit = "false";
		var returnvar = 0;
		var sModValue="";
			
			LIMultiValueArrays[iIndex] = m_return;
		
		} 		
		
	function getArrCount()
	{
		return arr_Count;
	}
	
	//Function - to create an new array with all the codes and the values to be set for flag
	function getArrReplaceCode(val){
	var sReturn="";
	sReturn= LIMultiValueArrays[val] ;
		return "" + sReturn;
	}
	 
	  //*****Getting the Code from the array list
	 function GetAllDescArrCodes(aSession,aType) {	
		var returnvar="";
		var x = 0;
		x = DescMultiArray.length;
		var i_Value = "0";
		var arr_list;
		var xLen =0;
		var iIndex=0;
		var sAbbValue="";
		var sTemp="";
		var sMultiDesc="";
		
		var sSession="[" + aSession.toUpperCase() + "]";
		var sType=aType.toUpperCase();
		
		var i = 0;
		for (i=0;i<=x;i++) 
		{
		sMultiDesc = DescMultiArray[i];
		  if (sMultiDesc == sSession)
			{
				 if (DescMultiTypeValueArray[i] == sType)
				 {
					 i_Value="1";
				 }
				else	{
					i_Value="0";
				}
				sAbbValue = DescMultiDescValueArray[i];
				
				if (sAbbValue.indexOf(",") >1){
					arr_list = sAbbValue.split(",");
					xLen= arr_list.length;

					for (iIndex=0;iIndex<=xLen;iIndex++) 
					{ 	
						sTemp=CreateArrayGeneric(arr_list[iIndex],i_Value);
					} 
				}
				else
				{
					sTemp=CreateArrayGeneric(sAbbValue,i_Value);
				}
			}
		}    
		return returnvar;
	 } 
	 
	 //Function - to create an new array with all the codes and the values to be set for flag
	
	var LIMultiValueArray = new Array();
	var LIMultiValueArrayValue = new Array();
	
	function CreateArrayGeneric( m_return, m_value) {	 
		var x = 0;
		x = LIMultiValueArray.length;
		var i = 0;
		var m_exit = "false";
		var returnvar = 0;
		var sModValue="";
		
		if (x == 0){
			LIMultiValueArray[0] = m_return;
			LIMultiValueArrayValue[0] = m_value;
		}
		else{

        for (i=0;i<=x;i++) 
        { 	
          if (LIMultiValueArray[i]== m_return)
            {
				if (m_value=="1"){
					LIMultiValueArrayValue[i] = m_value;
				}
			  m_exit = "true"; 
            }
		}    	
		if((m_exit == 'false') && (i > x))
			{ 
					LIMultiValueArray[x] = m_return;
					LIMultiValueArrayValue[x] = m_value;
			}	
		}

	}    		

	function getGenericCount(){
		return "" + LIMultiValueArray.length;
	}
	 
	//Function - to create an new array with all the codes and the values to be set for flag
	function getLIReplaceCode(val){
	var sReturn="";
	sReturn= LIMultiValueArray[val] ;
		return "" + sReturn;
	}

	//Function - to get the single value form the array
	function getLIFlagValue(val){
		return "" + LIMultiValueArrayValue[val] ;
	}
	
	//Function - Reset the array
	function ResetLICounter() {	 
		LIMultiValueArray.length=0;
		LIMultiValueArrayValue.length=0;
		
	} 
	
	//Function - Reset the array
	function ResetArrCounter() {	 
		LIMultiValueArrays.length=0;
	
		
	} 
//*****************************************************************
		]]>
    </msxsl:script>
<xsl:template name="FIBlock" match="/">
<FISpecificFields>
<iMMFIXSLVersion>1.3</iMMFIXSLVersion>
		<xsl:variable name="LoadArray">
				<xsl:value-of select="iMMScript:ReadFileintoArray()"/>
		</xsl:variable>
		
	<!-- Element Name is defined and its calling the GetDepartmentBranchValues function where the values of the drop-list is defiend.-->	
	<xsl:element name="CSTM_DEPT_BRANCH_VALUES">
		<xsl:if test="function-available('RKScript:GetDepartmentBranchValues')">
			<xsl:value-of select="RKScript:GetDepartmentBranchValues()"/>
		</xsl:if>
	</xsl:element>
</FISpecificFields>
</xsl:template>
</xsl:stylesheet> 
